function stk_explore(stk,varargin)
%A little function that allows you to take a stack, and view it as a movie
%with keyboard control.  Loads of fun for the whole family.
%Syntax: stk_explore(stk);
%Input:     stk = the image stack, 'nuff said.
%           delaly = a forced delay between each image in seconds.  Default = 0.05sec.
%Output:    None.

delay = parse(varargin);

rez = Screen(0,'Rect');     %Get the screen resolution
window=Screen(0,'OpenWindow',0);    %Prepare the window
hidecursor;                 %Hide the cursor
a = size(stk,3);                %# of images

%assign the keys to a variable
forward = kbname('right');      
back = kbname('left');
esc = kbname('esc');
%initialize the counter
count = 1;
%Display the images
while 1
    curr_frame = screen(window,'OpenOffscreenWindow',0);    %Create an off screen window
    %map the frame to the offscreen window
    screen(curr_frame,'PutImage',stk(:,:,count));
    screen(curr_frame,'DrawText',['frame: ',num2str(count)],10,750,255);    %Which frame is it?
    %Show the image
    screen('CopyWindow',curr_frame,window);
    %Wait for key press
    [hit,sec,key] = kbcheck;
    %Parse the key press and assign function
    if hit==1
        if key(forward)     %Move movie forward
            count = count+1;
            if count+1>a    %If at the end move to the beginning
                count = 1;
            end
        elseif key(back)    %Rewind
            count = count-1;
            if count-1<=0   %If at the beginning, go to the end.
                count = a;
            end
        end
        if key(esc)         %ESC exit loop
            break
        end
    end
    waitsecs(delay);      %A little pause so the movie is controlable
    screen(curr_frame,'Close'); %Clean up the screens so memory do not get clogged
end
%finish and clean up.
showcursor;
screen('CloseAll');

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function delay = parse(input)
%set defaults
delay = 0.05;

%Parse the input
if ~isempty(input)
    a = size(input,2);
    for i = 1:2:a
        value = input{1,i+1};
        switch input{1,i}
            case 'delay'
                if isnumeric(value) & size(value,2)==2
                    delay = value;
                else
                    error(['Error: You must enter a number for the delay value']);
                end
            otherwise
                error(['Error: You entered jibberish.']);
        end
    end
end
